//www.elegoo.com
//2016.12.08

#include "pitches.h"

#define KEY_1 A0
#define KEY_2 A1
#define KEY_3 A2
#define KEY_4 A3
#define KEY_5 A4
#define KEY_6 A5
#define KEY_7 A6
#define KEY_8 A7


int sequenceIdx=0;
const int sequenceCount = 17;

int melody[] = {
 NOTE_C3, NOTE_D3, NOTE_E3, NOTE_D3, NOTE_C3, NOTE_E3, NOTE_D3, NOTE_C3,
 NOTE_C3, NOTE_D3, NOTE_E3, NOTE_D3, NOTE_C3, NOTE_E3, NOTE_F3, NOTE_D3, NOTE_C3,
 NOTE_F3, NOTE_G3, NOTE_G3, NOTE_A3, NOTE_A3, NOTE_F3, NOTE_A3, NOTE_G3, NOTE_G3, NOTE_F3,
 NOTE_F3, NOTE_G3, NOTE_A3, NOTE_G3, NOTE_F3, NOTE_A3, NOTE_A3, NOTE_G3, NOTE_F3
};

// note durations: 4 = quarter note, 8 = eighth note, etc.:
int noteDurations[] = {
   2, 2, 2, 1, 1, 2, 2, 4,
   2, 2, 2, 1, 1, 1, 2, 1, 4,
   2, 1, 1, 1, 2, 1, 2, 1, 1, 4,
   2, 2, 2, 1, 1, 1, 2, 1, 3
};

void setup() {
  Serial.begin(9600);  // Initialize serial communications with the PC
  while (!Serial);     // Do nothing if no serial port is opened (added for Arduinos based on ATMEGA32U4)
  Serial.println("setup");
  pinMode(KEY_1, INPUT_PULLUP);
  pinMode(KEY_2, INPUT_PULLUP);
  pinMode(KEY_3, INPUT_PULLUP);
  pinMode(KEY_4, INPUT_PULLUP);
  pinMode(KEY_5, INPUT_PULLUP);
  pinMode(KEY_6, INPUT_PULLUP);
  pinMode(KEY_7, INPUT_PULLUP);
  pinMode(KEY_8, INPUT_PULLUP);
  pinMode(27, OUTPUT);
  digitalWrite(27, LOW);
}

// note assigned to each key
int notes[]={NOTE_C3,NOTE_D3,NOTE_E3,NOTE_F3,NOTE_G3,NOTE_A3,NOTE_B3,NOTE_C4};

int readKey( void )
{
   int key=-1;
   if (digitalRead(KEY_1) == LOW) key=0;
   else if (digitalRead(KEY_2) == LOW) key=1;
   else if (digitalRead(KEY_3) == LOW) key=2;
   else if (digitalRead(KEY_4) == LOW) key=3;
   else if (digitalRead(KEY_5) == LOW) key=4;
   else if (digitalRead(KEY_6) == LOW) key=5;
   else if (digitalRead(KEY_7) == LOW) key=6;
   else if (digitalRead(KEY_8) == LOW) key=7;
   //Serial.println(key);
   return key;
}

void PlayMusic( void )
{
  for (;sequenceIdx<sizeof(melody)/sizeof(melody[0]);sequenceIdx++)
  {
    int noteDuration = 125 * noteDurations[sequenceIdx];
    if (melody[sequenceIdx]) tone(8, melody[sequenceIdx], noteDuration);
    int pauseBetweenNotes = noteDuration * 1.30;
    delay(pauseBetweenNotes);
    noTone(8);
  }
  sequenceIdx=-1;
  // unlock
  digitalWrite(27,HIGH);
  delay(100);
  digitalWrite(27,LOW);
}

void loop() {
  if (sequenceIdx!=-1 && sequenceCount==0)
  {
    PlayMusic();
    return;
  }
  int key=readKey();

  if (key!=-1)
  {
    //Serial.println(sequenceIdx);
    if (sequenceIdx==-1)
    {
      tone(8, notes[key]);
      do
        delay(50);
      while (key==readKey());
      noTone(8);
    }
    else if (notes[key]==melody[sequenceIdx])
    {
      int noteDuration = 125 * noteDurations[sequenceIdx];
      tone(8, notes[key], noteDuration);
      int pauseBetweenNotes = noteDuration * 1.30;
      delay(pauseBetweenNotes);
      noTone(8);
      sequenceIdx++;
      if (sequenceIdx==sequenceCount)
      {
        PlayMusic();
        sequenceIdx=0;
        return;
      }
    }
    else
    {
      // error
      sequenceIdx=0;
      tone(8, NOTE_G3);
      delay(250);
      tone(8, NOTE_A2);
      delay(250);
      noTone(8);
      delay(250);
    }
    while (key==readKey())
    {
      delay(50);
    }
  }
}

